<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\ClassSession;

class CloseCompletedClasses extends Command
{
    /**
     * Nombre del comando
     */
    protected $signature = 'classes:close-completed';

    /**
     * Descripción
     */
    protected $description = 'Cierra automáticamente las clases cuando termina su horario';

    /**
     * Ejecutar el comando
     */
    public function handle(): int
    {
        ClassSession::whereIn('status', ['disponible', 'llena'])
            ->where('end_time', '<=', now())
            ->update([
                'status' => 'completada'
            ]);

        return Command::SUCCESS;
    }
}
