<?php

use App\Models\AdminLog;

if (! function_exists('admin_log')) {

    function admin_log(string $action, ?string $description = null): void
    {
        if (! auth()->check()) {
            return;
        }

        if (! auth()->user()->hasAnyRole(['admin','superadmin'])) {
            return;
        }

        AdminLog::create([
            'user_id' => auth()->id(),
            'action' => $action,
            'description' => $description,
        ]);
    }
}
