<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\User;
use App\Models\ClassSession;
use App\Models\Attendance;

class Agenda extends Component
{

    public $showAttendeesModal = false;
    public $selectedClass;
    public $attendances = [];
    public $selectedUser = null;

    public function removeAttendance($attendanceId)
{
    $attendance = Attendance::findOrFail($attendanceId);
    $subscription = $attendance->user->activeSubscription;

    // Regresar clase si aplica
    if ($subscription && $subscription->remaining_classes !== null) {
        $subscription->increment('remaining_classes');
    }

    $attendance->delete();

    // Actualizar estado de la clase si estaba llena
    if ($this->selectedClass->status === 'llena') {
        $this->selectedClass->update(['status' => 'disponible']);
    }

    // Refrescar datos del modal
    $this->openAttendeesModal($this->selectedClass->id);
}


    public function openAttendeesModal($classId)
{
    $this->selectedClass = ClassSession::with('attendances.user')
        ->findOrFail($classId);

    $this->attendances = $this->selectedClass->attendances;

    $this->showAttendeesModal = true;
}


    public function render()
    {
        return view('livewire.admin.agenda', [
            'users' => User::role('cliente')->where('is_active', true)->get(),

            'classes' => ClassSession::with(['coach','discipline','attendances'])
                ->where('status', 'disponible')
                ->where('start_time', '>', now())
                ->orderBy('start_time')
                ->get(),
        ]);
    }

    public function book($classId)
    {
        if (! $this->selectedUser) {
            $this->addError('selectedUser', 'Selecciona un cliente');
            return;
        }

        $user = User::findOrFail($this->selectedUser);
        $class = ClassSession::findOrFail($classId);

        // 1️⃣ Suscripción activa
        $subscription = $user->activeSubscription;

        if (! $subscription) {
            abort(403, 'El cliente no tiene una suscripción activa');
        }

        // 2️⃣ Clases disponibles
        if (
            $subscription->remaining_classes !== null &&
            $subscription->remaining_classes <= 0
        ) {
            abort(403, 'El cliente no tiene clases disponibles');
        }

        // 3️⃣ Cupo disponible
        if ($class->availableSpots() <= 0) {
            abort(403, 'Clase llena');
        }

        // 4️⃣ Evitar doble reserva
        if (
            Attendance::where('user_id', $user->id)
                ->where('class_session_id', $class->id)
                ->exists()
        ) {
            abort(403, 'El cliente ya está inscrito en esta clase');
        }

        // 5️⃣ Crear asistencia
        Attendance::create([
            'user_id' => $user->id,
            'class_session_id' => $class->id,
        ]);

        // 6️⃣ Descontar clase
        if ($subscription->remaining_classes !== null) {
            $subscription->decrement('remaining_classes');
        }

        // 7️⃣ Marcar clase llena si aplica
        if ($class->availableSpots() <= 0) {
            $class->update(['status' => 'llena']);
        }
    }
}
