<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ClassSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'coach_id',
        'discipline_id',
        'start_time',
        'end_time',
        'max_capacity',
        'status',
    ];

    /**
     * Casts automáticos
     */
    protected $casts = [
        'start_time' => 'datetime',
        'end_time'   => 'datetime',
    ];

    /**
     * Relaciones
     */
    public function coach()
    {
        return $this->belongsTo(Coach::class);
    }

    public function discipline()
    {
        return $this->belongsTo(Discipline::class);
    }

    /**
     * Asistencias (para cupo y control)
     */
    public function attendances()
    {
        return $this->hasMany(Attendance::class);
    }

    /**
     * Cupos disponibles (MUY IMPORTANTE)
     */
    public function availableSpots(): int
    {
        return $this->max_capacity - $this->attendances()->count();
    }

    /**
     * Helpers de estado (opcional pero limpio)
     */
    public function isDisponible(): bool
    {
        return $this->status === 'disponible';
    }

    public function isLlena(): bool
    {
        return $this->status === 'llena';
    }

    public function isCancelada(): bool
    {
        return $this->status === 'cancelada';
    }

    public function isCompletada(): bool
    {
        return $this->status === 'completada';
    }
}
