<?php

namespace App\Livewire\Admin\History;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Attendance;
use App\Models\User;
use App\Models\ClassSession;
use App\Models\Discipline;

class Attendanceh extends Component
{
    use WithPagination;

    protected $paginationTheme = 'tailwind';

    public $user_id;
    public $class_session_id;
    public $discipline_id;
    public $from;
    public $to;

    public function render()
    {
        $query = Attendance::with([
            'user',
            'classSession.coach',
            'classSession.discipline',
        ])->orderBy('created_at', 'desc');

        if ($this->user_id) {
            $query->where('user_id', $this->user_id);
        }

        if ($this->class_session_id) {
            $query->where('class_session_id', $this->class_session_id);
        }

        if ($this->discipline_id) {
            $query->whereHas('classSession', fn ($q) =>
                $q->where('discipline_id', $this->discipline_id)
            );
        }

        if ($this->from) {
            $query->whereDate('created_at', '>=', $this->from);
        }

        if ($this->to) {
            $query->whereDate('created_at', '<=', $this->to);
        }

        return view('livewire.admin.history.asistencia', [
            'attendances' => $query->paginate(15),
            'users' => User::role('cliente')->get(),
            'classes' => ClassSession::orderBy('start_time')->get(),
            'disciplines' => Discipline::all(),
        ]);
    }

    public function resetFilters()
    {
        $this->reset([
            'user_id',
            'class_session_id',
            'discipline_id',
            'from',
            'to',
        ]);
    }
}
