<?php

namespace App\Livewire\Admin\History;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Payment;
use App\Models\User;

class Payments extends Component
{
    use WithPagination;

    protected $paginationTheme = 'tailwind';

    public $user_id;
    public $method;
    public $provider;
    public $from;
    public $to;

    public function render()
    {
        $query = Payment::with(['user','package','promotion'])
            ->orderBy('paid_at', 'desc');

        if ($this->user_id) {
            $query->where('user_id', $this->user_id);
        }

        if ($this->method) {
            $query->where('payment_method', $this->method);
        }

        if ($this->provider) {
            $query->where('provider', $this->provider);
        }

        if ($this->from) {
            $query->whereDate('paid_at', '>=', $this->from);
        }

        if ($this->to) {
            $query->whereDate('paid_at', '<=', $this->to);
        }

        return view('livewire.admin.history.payments', [
            'payments' => $query->paginate(15),
            'users' => User::role('cliente')->get(),
        ]);
    }

    public function resetFilters()
    {
        $this->reset([
            'user_id',
            'method',
            'provider',
            'from',
            'to',
        ]);
    }
}
