<?php

namespace App\Livewire\Admin\History;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Subscription;
use App\Models\User;
use App\Models\Package;

class Subscriptions extends Component
{
    use WithPagination;

    protected $paginationTheme = 'tailwind';

    public $user_id;
    public $status;
    public $package_id;
    public $from;
    public $to;

    public array $statuses = [
        'activa',
        'pausada',
        'cancelada',
        'vencida',
        'pendiente_pago',
    ];

    public function render()
    {
        $query = Subscription::with(['user','package'])
            ->orderBy('start_date', 'desc');

        if ($this->user_id) {
            $query->where('user_id', $this->user_id);
        }

        if ($this->status) {
            $query->where('status', $this->status);
        }

        if ($this->package_id) {
            $query->where('package_id', $this->package_id);
        }

        if ($this->from) {
            $query->whereDate('start_date', '>=', $this->from);
        }

        if ($this->to) {
            $query->whereDate('end_date', '<=', $this->to);
        }

        return view('livewire.admin.history.subscriptions', [
            'subscriptions' => $query->paginate(15),
            'users' => User::role('cliente')->get(),
            'packages' => Package::all(),
        ]);
    }

    public function resetFilters()
    {
        $this->reset([
            'user_id',
            'status',
            'package_id',
            'from',
            'to',
        ]);
    }
}
