<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Package;

class Packages extends Component
{
    use WithPagination;

    protected $paginationTheme = 'tailwind';

    public $search = '';
    public $showModal = false;
    public $editMode = false;

    public $packageId;
    public $name;
    public $description;
    public $price;
    public $classes_limit;
    public $duration_days;
    public $is_subscription = false;
    public $is_active = true;

    protected function rules()
    {
        return [
            'name' => 'required|string|min:3',
            'price' => 'required|numeric|min:0',
            'duration_days' => 'required|integer|min:1',
            'classes_limit' => 'nullable|integer|min:1',
            'is_subscription' => 'boolean',
        ];
    }

    public function render()
    {
        return view('livewire.admin.packages', [
            'packages' => Package::where('name', 'like', "%{$this->search}%")
                ->orderBy('price')
                ->paginate(10),
        ]);
    }

    public function create()
    {
        $this->resetFields();
        $this->editMode = false;
        $this->showModal = true;
    }

    public function edit(Package $package)
    {
        $this->packageId = $package->id;
        $this->name = $package->name;
        $this->description = $package->description;
        $this->price = $package->price;
        $this->classes_limit = $package->classes_limit;
        $this->duration_days = $package->duration_days;
        $this->is_subscription = $package->is_subscription;
        $this->is_active = $package->is_active;

        $this->editMode = true;
        $this->showModal = true;
    }

    public function save()
    {
        $this->validate();

        $data = [
            'name' => $this->name,
            'description' => $this->description,
            'price' => $this->price,
            'classes_limit' => $this->classes_limit,
            'duration_days' => $this->duration_days,
            'is_subscription' => $this->is_subscription,
            'is_active' => $this->is_active,
        ];

        if ($this->editMode) {
            Package::findOrFail($this->packageId)->update($data);
        } else {
            Package::create($data);
        }

        $this->showModal = false;
        $this->resetFields();
    }

    public function toggleStatus(Package $package)
    {
        $package->update([
            'is_active' => ! $package->is_active
        ]);
    }

    private function resetFields()
    {
        $this->reset([
            'packageId',
            'name',
            'description',
            'price',
            'classes_limit',
            'duration_days',
            'is_subscription',
            'is_active',
        ]);
    }
}
