<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Package extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'price',
        'classes_limit', // null = ilimitado
        'duration_days',
        'is_subscription',
        'is_active',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_subscription' => 'boolean',
        'is_active' => 'boolean',
    ];

    /**
     * Relación con suscripciones
     */
    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }

    /**
     * Helpers
     */
    public function isUnlimited(): bool
    {
        return is_null($this->classes_limit);
    }
}
