<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Carbon\Carbon;


class Promotion extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'discount_percent',
        'valid_from',
        'valid_to',
        'active',
    ];

    protected $casts = [
        'valid_from' => 'date',
        'valid_to'   => 'date',
        'active'     => 'boolean',
    ];

    /*
    |--------------------------------------------------------------------------
    | HELPERS
    |--------------------------------------------------------------------------
    */

    public function isValid(): bool
    {
        $now = Carbon::today();

        if (! $this->active) {
            return false;
        }

        if ($this->valid_from && $now->lt($this->valid_from)) {
            return false;
        }

        if ($this->valid_to && $now->gt($this->valid_to)) {
            return false;
        }

        return true;
    }

    public function apply(float $amount): float
    {
        if (! $this->isValid()) {
            return $amount;
        }

        return max(
            $amount - ($amount * ($this->discount_percent / 100)),
            0
        );
    }
}
