<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'package_id',
        'start_date',
        'end_date',
        'status',
        'remaining_classes',
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date'   => 'datetime',
    ];

    /**
     * Relaciones
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function package()
    {
        return $this->belongsTo(Package::class);
    }

    /**
     * Helpers de estado
     */
    public function isActive(): bool
    {
        return $this->status === 'activa';
    }

    public function isPaused(): bool
    {
        return $this->status === 'pausada';
    }

    public function isCancelled(): bool
    {
        return $this->status === 'cancelada';
    }

    public function isExpired(): bool
    {
        return $this->status === 'vencida';
    }

    public function isPendingPayment(): bool
    {
        return $this->status === 'pendiente_pago';
    }
}
