<?php

namespace App\Services;

use App\Models\OpenpaySetting;
use Openpay;

class OpenpayService
{
    public static function client()
    {
        $settings = OpenpaySetting::firstOrFail();

        if ($settings->mode === 'production') {
            Openpay::setProductionMode(true);

            return Openpay::getInstance(
                $settings->production_merchant_id,
                $settings->production_private_key,
                $settings->production_endpoint
            );
        }

        Openpay::setProductionMode(false);

        return Openpay::getInstance(
            $settings->sandbox_merchant_id,
            $settings->sandbox_private_key,
            $settings->sandbox_endpoint
        );
    }
}
