<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('subscriptions', function (Blueprint $table) {
  $table->id();
  $table->foreignId('user_id')->constrained()->cascadeOnDelete();
  $table->foreignId('package_id')->constrained()->cascadeOnDelete();
  $table->enum('status', [
      'activa',
      'pausada',
      'cancelada',
      'vencida',
      'pendiente_pago'
  ])->default('pendiente_pago');
  $table->date('start_date')->nullable();
  $table->date('end_date')->nullable();
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
