<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('payments', function (Blueprint $table) {
  $table->id();
  $table->foreignId('user_id')->constrained()->cascadeOnDelete();
  $table->decimal('amount', 10, 2);
  $table->string('method')->nullable();
  $table->string('openpay_transaction_id')->nullable();
  $table->enum('status', [
      'pendiente',
      'pagado',
      'fallido',
      'reembolsado'
  ])->default('pendiente');
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
