<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::table('payments', function (Blueprint $table) {
  $table->string('payment_method')
      ->after('amount')
      ->comment('efectivo | tarjeta | transferencia');

  $table->string('provider')
      ->nullable()
      ->after('payment_method')
      ->comment('openpay | manual');

  $table->timestamp('paid_at')
      ->nullable()
      ->after('status');
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            //
        });
    }
};
