<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            // Usuarios
            'ver usuarios','crear usuarios','editar usuarios','eliminar usuarios',

            // Clases
            'ver clases','crear clases','editar clases','cancelar clases',

            // Paquetes
            'ver paquetes','crear paquetes','editar paquetes','eliminar paquetes',

            // Pagos
            'ver pagos','reembolsar pagos',

            // Configuración
            'ver configuracion','editar configuracion',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }
    }
}
