<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        $admin = Role::where('name', 'admin')->first();
        $superadmin = Role::where('name', 'superadmin')->first();

        if (!$admin || !$superadmin) {
            return;
        }

        // Permisos para ADMIN
        $admin->syncPermissions([
            'ver usuarios',
            'editar usuarios',

            'ver clases',
            'crear clases',
            'editar clases',
            'cancelar clases',

            'ver paquetes',
            'ver pagos',
        ]);

        // SUPERADMIN tiene TODOS los permisos
        $superadmin->syncPermissions(
            Permission::all()
        );
    }
}
