@props([
    'variant' => 'primary',
    'type' => 'button'
])

@php
$styles = match($variant) {
    'primary' => 'bg-purple-600 hover:bg-purple-700 text-white',
    'secondary' => 'bg-gray-200 hover:bg-gray-300 text-gray-800',
    'danger' => 'bg-red-600 hover:bg-red-700 text-white',
    'warning' => 'bg-yellow-500 hover:bg-yellow-600 text-white',
    default => 'bg-gray-200'
};
@endphp

<button
    type="{{ $type }}"
    {{ $attributes->merge([
        'class' =>
        'px-4 py-2 rounded-xl font-medium transition duration-200 ' . $styles
    ]) }}
>
    {{ $slot }}
</button>
