@props(['show'])

@if($show)
<div
    class="fixed inset-0 z-50 flex items-center justify-center"
    aria-modal="true"
    role="dialog"
>
    {{-- BACKDROP --}}
    <div
        class="absolute inset-0 bg-black/60 backdrop-blur-sm"
        wire:click="$set('showModal', false)"
    ></div>

    {{-- MODAL --}}
    <div
        class="relative bg-white
               w-full max-w-lg
               mx-4
               rounded-2xl
               shadow-2xl
               overflow-hidden
               animate-fade-in"
    >
        {{-- HEADER --}}
        @isset($header)
        <div class="px-6 py-4 border-b bg-gray-50">
            {{ $header }}
        </div>
        @endisset

        {{-- BODY --}}
        <div class="px-6 py-5 space-y-3">
            {{ $slot }}
        </div>

        {{-- FOOTER --}}
        @isset($footer)
        <div class="px-6 py-4 border-t bg-gray-50 flex justify-end gap-3">
            {{ $footer }}
        </div>
        @endisset
    </div>
</div>
@endif
