<div>

    {{-- HEADER --}}
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold">Coaches</h1>
            <p class="text-gray-600">Administración de instructores</p>
        </div>

        <x-button wire:click="create">
            + Nuevo Coach
        </x-button>
    </div>

    {{-- SEARCH --}}
    <input
        wire:model.live="search"
        class="w-full mb-4 border rounded-xl p-2"
        placeholder="Buscar coach..."
    >

    {{-- TABLE --}}
    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Coach</th>
                <th>Biografía</th>
                <th>Estado</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($coaches as $coach)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3 flex items-center gap-3">
                    @if($coach->photo)
                        <img
                            src="{{ asset('storage/'.$coach->photo) }}"
                            class="w-10 h-10 rounded-full object-cover"
                        >
                    @endif
                    {{ $coach->name }}
                </td>
                <td class="text-sm text-gray-600">
                    {{ Str::limit($coach->bio, 60) }}
                </td>
                <td>
                    @if($coach->is_active)
                        <span class="text-green-600 font-semibold">Activo</span>
                    @else
                        <span class="text-red-600 font-semibold">Inactivo</span>
                    @endif
                </td>
                <td class="text-right space-x-2 pr-4">
                    <x-button variant="secondary" wire:click="edit({{ $coach->id }})">
                        Editar
                    </x-button>
                    <x-button variant="warning" wire:click="toggleStatus({{ $coach->id }})">
                        {{ $coach->is_active ? 'Desactivar' : 'Activar' }}
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $coaches->links() }}
    </div>

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar Coach' : 'Nuevo Coach' }}
            </h2>
        </x-slot>

        <input
            wire:model="name"
            class="w-full border rounded-xl p-2"
            placeholder="Nombre del coach"
        >

        <textarea
            wire:model="bio"
            class="w-full border rounded-xl p-2"
            rows="3"
            placeholder="Biografía"
        ></textarea>

        <input
            type="file"
            wire:model="photo"
            class="w-full border rounded-xl p-2"
        >

        @if ($photo)
            <img src="{{ $photo->temporaryUrl() }}"
                 class="w-24 h-24 rounded-full object-cover mx-auto">
        @endif

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>

            <x-button wire:click="save">
                Guardar
            </x-button>
        </x-slot>

    </x-modal>

</div>
