<div>

    {{-- HEADER --}}
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold">Disciplinas</h1>
            <p class="text-gray-600">Administración de disciplinas</p>
        </div>

        <x-button wire:click="create">
            + Nueva Disciplina
        </x-button>
    </div>

    {{-- SEARCH --}}
    <input
        wire:model.live="search"
        class="w-full mb-4 border rounded-xl p-2"
        placeholder="Buscar disciplina..."
    >

    {{-- TABLE --}}
    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Nombre</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($disciplines as $discipline)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3 font-medium">
                    {{ $discipline->name }}
                </td>
                <td class="text-sm text-gray-600">
                    {{ \Illuminate\Support\Str::limit($discipline->description, 60) }}
                </td>
                <td>
                    @if($discipline->is_active)
                        <span class="text-green-600 font-semibold">Activa</span>
                    @else
                        <span class="text-red-600 font-semibold">Inactiva</span>
                    @endif
                </td>
                <td class="text-right space-x-2 pr-4">
                    <x-button variant="icon" wire:click="edit({{ $discipline->id }})">
                        ✏️
                    </x-button>

                    <x-button
                        variant="{{ $discipline->is_active ? 'warning' : 'primary' }}"
                        wire:click="toggleStatus({{ $discipline->id }})"
                    >
                        {{ $discipline->is_active ? 'Desactivar' : 'Activar' }}
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $disciplines->links() }}
    </div>

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar Disciplina' : 'Nueva Disciplina' }}
            </h2>
        </x-slot>

        <input
            wire:model="name"
            class="w-full border rounded-xl p-2"
            placeholder="Nombre de la disciplina"
        >

        <textarea
            wire:model="description"
            class="w-full border rounded-xl p-2"
            rows="3"
            placeholder="Descripción"
        ></textarea>

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>

            <x-button wire:click="save">
                Guardar
            </x-button>
        </x-slot>

    </x-modal>

</div>
