<div>

    <h1 class="text-2xl font-bold mb-4">
        Asistencia a Clases
    </h1>

    {{-- FILTROS --}}
    <div class="bg-white p-4 rounded-xl shadow mb-6 grid grid-cols-1 md:grid-cols-6 gap-3">

        <select wire:model.live="user_id" class="border rounded-lg p-2">
            <option value="">Todos los clientes</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">{{ $user->name }}</option>
            @endforeach
        </select>

        <select wire:model.live="class_session_id" class="border rounded-lg p-2">
            <option value="">Todas las clases</option>
            @foreach($classes as $class)
                <option value="{{ $class->id }}">
                    {{ $class->discipline->name }}
                    ({{ $class->start_time->format('d/m H:i') }})
                </option>
            @endforeach
        </select>

        <select wire:model.live="discipline_id" class="border rounded-lg p-2">
            <option value="">Todas las disciplinas</option>
            @foreach($disciplines as $discipline)
                <option value="{{ $discipline->id }}">{{ $discipline->name }}</option>
            @endforeach
        </select>

        <input wire:model.live="from" type="date" class="border rounded-lg p-2">
        <input wire:model.live="to" type="date" class="border rounded-lg p-2">

        <button
            wire:click="resetFilters"
            class="bg-gray-200 hover:bg-gray-300 rounded-lg p-2"
        >
            Limpiar
        </button>

    </div>

    {{-- TABLA --}}
    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Cliente</th>
                <th>Clase</th>
                <th>Coach</th>
                <th>Fecha</th>
                <th>Asistió</th>
            </tr>
        </thead>
        <tbody>
            @forelse($attendances as $attendance)
                <tr class="border-t">
                    <td class="p-3">{{ $attendance->user->name }}</td>
                    <td>{{ $attendance->classSession->discipline->name }}</td>
                    <td>{{ $attendance->classSession->coach->name }}</td>
                    <td>
                        {{ optional($attendance->attended_at)->format('d/m/Y H:i') ?? '—' }}
                    </td>
                    <td>
                        @if($attendance->attended_at)
                            <span class="text-green-600 font-semibold">Sí</span>
                        @else
                            <span class="text-red-500">No</span>
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="p-4 text-center text-gray-400">
                        No hay registros de asistencia
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $attendances->links() }}
    </div>

</div>
