<div>

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">
            Pagos de Hoy
        </h1>

        <x-button wire:click="create">
            + Nuevo Pago
        </x-button>
    </div>

    <table class="w-full bg-white rounded-xl shadow">
        <thead>
            <tr class="text-left text-sm text-gray-500">
                <th class="p-3">Cliente</th>
                <th>Paquete</th>
                <th>Monto</th>
                <th>Método</th>
                <th>Promo</th>
                <th>Hora</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payments as $payment)
            <tr class="border-t">
                <td class="p-3">{{ $payment->user->name }}</td>
                <td>{{ $payment->package->name }}</td>
                <td>${{ number_format($payment->amount, 2) }}</td>
                <td class="capitalize">{{ $payment->payment_method }}</td>
                <td>
                  @if($payment->promotion_percent)
                    {{ $payment->promotion_percent }}%
                    @else
                      —
                    @endif
                </td>
                <td>{{ $payment->created_at->format('H:i') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                Registrar Pago Manual
            </h2>
        </x-slot>

        <select wire:model="user_id" class="w-full border rounded-xl p-2">
            <option value="">Seleccionar cliente</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">{{ $user->name }}</option>
            @endforeach
        </select>

        <select wire:model.live="package_id" class="w-full border rounded-xl p-2">
            <option value="">Seleccionar paquete</option>
            @foreach($packages as $package)
                <option value="{{ $package->id }}">{{ $package->name }}</option>
            @endforeach
        </select>

        <input
            type="number"
            wire:model.live="amount"
            class="w-full border rounded-xl p-2"
            readonly
        "$">

        @if($discount_percent)
    <p class="text-sm text-green-600">
        Promoción aplicada: {{ $discount_percent }}% de descuento
    </p>

    <p class="text-xs text-gray-500">
        Precio original: ${{ number_format($original_amount, 2) }}
    </p>
@endif


        <select wire:model="payment_method" class="w-full border rounded-xl p-2">
            <option value="">Método de pago</option>
            @foreach($methods as $method)
                <option value="{{ $method }}">{{ ucfirst($method) }}</option>
            @endforeach
        </select>

        <x-slot name="footer">
            <x-button
                variant="secondary"
                wire:click="$set('showModal', false)"
            >
                Cancelar
            </x-button>

            <x-button wire:click="save">
                Guardar Pago
            </x-button>
        </x-slot>

    </x-modal>

</div>
