<div>

    {{-- HEADER --}}
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold">Suscripciones</h1>
            <p class="text-gray-600">Gestión de suscripciones de clientes</p>
        </div>

        <x-button wire:click="create">
            + Nueva Suscripción
        </x-button>
    </div>

    {{-- SEARCH --}}
    <input
        wire:model.live="search"
        class="w-full mb-4 border rounded-xl p-2"
        placeholder="Buscar por cliente..."
    >

    {{-- TABLE --}}
    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Cliente</th>
                <th>Paquete</th>
                <th>Vigencia</th>
                <th>Clases</th>
                <th>Estado</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($subscriptions as $sub)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3">{{ $sub->user->name }}</td>
                <td>{{ $sub->package->name }}</td>
                <td class="text-sm">
                    {{ $sub->start_date->format('d/m/Y') }}
                    –
                    {{ $sub->end_date?->format('d/m/Y') ?? '—' }}
                </td>
                <td>
                    {{ $sub->remaining_classes ?? 'Ilimitadas' }}
                </td>
                <td>
                    <span class="px-2 py-1 rounded text-xs font-semibold
                        @if($sub->status === 'activa') bg-green-100 text-green-700
                        @elseif($sub->status === 'pausada') bg-yellow-100 text-yellow-700
                        @elseif($sub->status === 'pendiente_pago') bg-orange-100 text-orange-700
                        @elseif($sub->status === 'cancelada') bg-red-100 text-red-700
                        @else bg-gray-200 text-gray-700
                        @endif
                    ">
                        {{ ucfirst(str_replace('_',' ',$sub->status)) }}
                    </span>
                </td>
                <td class="text-right space-x-2 pr-4">
                    <x-button variant="secondary" wire:click="edit({{ $sub->id }})">
                        Editar
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $subscriptions->links() }}

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar Suscripción' : 'Nueva Suscripción' }}
            </h2>
        </x-slot>

        <select wire:model="user_id" class="w-full border rounded-xl p-2">
            <option value="">Selecciona Cliente</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">{{ $user->name }}</option>
            @endforeach
        </select>

        <select wire:model="package_id" class="w-full border rounded-xl p-2">
            <option value="">Selecciona Paquete</option>
            @foreach($packages as $package)
                <option value="{{ $package->id }}">{{ $package->name }}</option>
            @endforeach
        </select>

        <select wire:model="status" class="w-full border rounded-xl p-2">
            @foreach($statuses as $status)
                <option value="{{ $status }}">{{ ucfirst(str_replace('_',' ',$status)) }}</option>
            @endforeach
        </select>

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>
            <x-button wire:click="save">
                Guardar
            </x-button>
        </x-slot>

    </x-modal>

</div>
