<div class="flex min-h-screen bg-gray-100">

    {{-- SIDEBAR --}}
    <aside class="w-64 bg-gray-900 text-white p-4 space-y-4">

        <h2 class="text-xl font-bold text-purple-400">
            Panel Superadmin
        </h2>

            <button wire:click="$set('section','users')" class="block w-full text-left p-2 hover:bg-gray-700 rounded">
                Usuarios y Roles
            </button>

            <button wire:click="$set('section','permissions')" class="block w-full text-left p-2 hover:bg-gray-700 rounded">
                Permisos
            </button>

            <button wire:click="$set('section','openpay-webhooks')" class="block w-full text-left p-2 hover:bg-gray-700 rounded">
                Webhooks OpenPay
            </button>

            <button wire:click="$set('section','openpay-settings')" class="block w-full text-left p-2 hover:bg-gray-700 rounded">
                Configuración OpenPay
            </button>

        </nav>
    </aside>

    {{-- CONTENT --}}
    <main class="flex-1 p-6">

        @switch($section)

            @case('users')
                <livewire:super-admin.users />
                @break

            @case('permissions')
                <livewire:super-admin.permissions />
                @break

                @case('openpay-webhooks')
        <livewire:super-admin.openpay.webhooks />
        @break


        @case('openpay-settings')
<livewire:super-admin.openpay.settings />
@break


        @endswitch

    </main>
</div>
