<div>

    <div class="mb-6">
        <h1 class="text-2xl font-bold">Configuración OpenPay</h1>
        <p class="text-gray-600">
            Configura credenciales y entorno de OpenPay
        </p>
    </div>

    @if (session()->has('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded-xl">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-2xl shadow p-6 space-y-6">

        {{-- MODO --}}
        <div>
            <label class="font-semibold">Modo de operación</label>
            <select wire:model="mode" class="w-full border rounded-xl p-2 mt-1">
                <option value="sandbox">Sandbox (Pruebas)</option>
                <option value="production">Producción</option>
            </select>
        </div>

        {{-- SANDBOX --}}
        <div>
            <h2 class="font-bold text-lg mb-2">Sandbox (Obligatorio)</h2>

            <input wire:model="sandbox_merchant_id" class="w-full border rounded-xl p-2 mb-2" placeholder="Merchant ID">
            <input wire:model="sandbox_public_key" class="w-full border rounded-xl p-2 mb-2" placeholder="Public Key">
            <input wire:model="sandbox_private_key" type="password" class="w-full border rounded-xl p-2 mb-2" placeholder="Private Key">
            <input wire:model="sandbox_endpoint" class="w-full border rounded-xl p-2" placeholder="Endpoint">
        </div>

        {{-- PRODUCCIÓN --}}
        <div>
            <h2 class="font-bold text-lg mb-2">Producción (Opcional)</h2>

            <input wire:model="production_merchant_id" class="w-full border rounded-xl p-2 mb-2" placeholder="Merchant ID">
            <input wire:model="production_public_key" class="w-full border rounded-xl p-2 mb-2" placeholder="Public Key">
            <input wire:model="production_private_key" type="password" class="w-full border rounded-xl p-2 mb-2" placeholder="Private Key">
            <input wire:model="production_endpoint" class="w-full border rounded-xl p-2" placeholder="Endpoint">
        </div>

        <div class="flex justify-end">
            <x-button wire:click="save">
                Guardar Configuración
            </x-button>
        </div>

    </div>

</div>
