<?php

use Illuminate\Support\Facades\Schedule;
use App\Models\ClassSession;

/*
|--------------------------------------------------------------------------
| CIERRE AUTOMÁTICO DE CLASES
|--------------------------------------------------------------------------
*/

Schedule::call(function () {

    ClassSession::where('end_time', '<=', now())
        ->whereNotIn('status', ['completada', 'cancelada'])
        ->update([
            'status' => 'completada'
        ]);

})->everyMinute();


/*
|--------------------------------------------------------------------------
| VENCIMIENTO AUTOMÁTICO DE SUSCRIPCIONES
|--------------------------------------------------------------------------
*/

Schedule::command('subscriptions:expire')
    ->dailyAt('00:05');
