<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Livewire\Admin\Dashboard as AdminDashboard;
use App\Livewire\SuperAdmin\Dashboard as SuperAdminDashboard;
use App\Livewire\User\Dashboard as UserDashboard;

Route::middleware(['auth', 'role:cliente'])->group(function () {
    Route::get('/user/dashboard', UserDashboard::class);
});


Route::middleware(['auth', 'role:superadmin'])->group(function () {
    Route::get('/superadmin/dashboard', SuperAdminDashboard::class);
});


Route::middleware(['auth', 'role:admin|superadmin'])->group(function () {
    Route::get('/admin/dashboard', AdminDashboard::class);
});


Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth'])
    ->name('dashboard');


Route::get('/', function () {
    return view('welcome');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
});

Route::get('/', function () {
    return view('welcome');
});

/* PANEL USUARIO */
Route::middleware(['auth','role:cliente'])
    ->get('/user/dashboard', \App\Livewire\User\Dashboard::class);


/* PANEL ADMIN */
Route::middleware(['auth', 'role:admin|superadmin'])->group(function () {
    Route::get('/admin/dashboard', fn () => view('admin.dashboard'));
});

/* PANEL SUPERADMIN */
Route::middleware(['auth', 'role:superadmin'])->group(function () {
    Route::get('/superadmin/dashboard', fn () => view('superadmin.dashboard'));
});
