<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Livewire\User\Dashboard as UserDashboard;
use App\Livewire\Admin\Dashboard as AdminDashboard;
use App\Livewire\SuperAdmin\Dashboard as SuperAdminDashboard;

/*
|--------------------------------------------------------------------------
| RUTA PÚBLICA
|--------------------------------------------------------------------------
*/
Route::get('/', function () {
    return view('welcome');
});

/*
|--------------------------------------------------------------------------
| DASHBOARD CENTRAL (REDIRECCIONA SEGÚN ROL)
|--------------------------------------------------------------------------
*/
Route::middleware(['auth'])->get('/dashboard', [DashboardController::class, 'index'])
    ->name('dashboard');

/*
|--------------------------------------------------------------------------
| PANEL CLIENTE
|--------------------------------------------------------------------------
*/
Route::middleware(['auth', 'role:cliente'])->group(function () {
    Route::get('/user/dashboard', UserDashboard::class)
        ->name('user.dashboard');
});

/*
|--------------------------------------------------------------------------
| PANEL ADMIN
|--------------------------------------------------------------------------
*/
Route::middleware(['auth', 'role:admin|superadmin'])->group(function () {
    Route::get('/admin/dashboard', AdminDashboard::class)
        ->name('admin.dashboard');
});

/*
|--------------------------------------------------------------------------
| PANEL SUPERADMIN
|--------------------------------------------------------------------------
*/
Route::middleware(['auth', 'role:superadmin'])->group(function () {
    Route::get('/superadmin/dashboard', SuperAdminDashboard::class)
        ->name('superadmin.dashboard');
});
