<div>

    <h1 class="text-2xl font-bold mb-4">
        Historial de Pagos
    </h1>

    
    <div class="bg-white p-4 rounded-xl shadow mb-6 grid grid-cols-1 md:grid-cols-5 gap-3">

        <select wire:model.live="user_id" class="border rounded-lg p-2">
            <option value="">Todos los clientes</option>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </select>

        <select wire:model.live="method" class="border rounded-lg p-2">
            <option value="">Método</option>
            <option value="efectivo">Efectivo</option>
            <option value="tarjeta">Tarjeta</option>
            <option value="transferencia">Transferencia</option>
        </select>

        <select wire:model.live="provider" class="border rounded-lg p-2">
            <option value="">Proveedor</option>
            <option value="manual">Manual</option>
            <option value="openpay">OpenPay</option>
        </select>

        <input wire:model.live="from" type="date" class="border rounded-lg p-2">
        <input wire:model.live="to" type="date" class="border rounded-lg p-2">

        <button
            wire:click="resetFilters"
            class="md:col-span-5 bg-gray-200 hover:bg-gray-300 rounded-lg p-2"
        >
            Limpiar filtros
        </button>

    </div>

    
    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Fecha</th>
                <th>Cliente</th>
                <th>Paquete</th>
                <th>Monto</th>
                <th>Promo</th>
                <th>Método</th>
                <th>Proveedor</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-t">
                    <td class="p-3">
                        <?php echo e(optional($payment->paid_at)->format('d/m/Y H:i')); ?>

                    </td>
                    <td><?php echo e($payment->user->name); ?></td>
                    <td><?php echo e($payment->package->name); ?></td>
                    <td>$<?php echo e(number_format($payment->amount, 2)); ?></td>
                    <td>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment->promotion_percent): ?>
                            <?php echo e($payment->promotion_percent); ?>%
                        <?php else: ?>
                            —
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </td>
                    <td class="capitalize"><?php echo e($payment->payment_method); ?></td>
                    <td class="capitalize"><?php echo e($payment->provider); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="p-4 text-center text-gray-400">
                        No hay pagos registrados
                    </td>
                </tr>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    <div class="mt-4">
        <?php echo e($payments->links()); ?>

    </div>

</div>
<?php /**PATH C:\laragon\www\pilates-app\resources\views/livewire/admin/history/payments.blade.php ENDPATH**/ ?>