<div>

    <div class="mb-6">
        <h1 class="text-2xl font-bold">Webhooks OpenPay</h1>
        <p class="text-gray-600">
            Eventos recibidos desde OpenPay
        </p>
    </div>

    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Fecha</th>
                <th>Evento</th>
                <th>Transacción</th>
                <th>Estado</th>
                <th class="text-right pr-4">Payload</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $webhooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webhook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3"><?php echo e($webhook->created_at); ?></td>
                <td><?php echo e($webhook->event_type); ?></td>
                <td><?php echo e($webhook->transaction_id); ?></td>
                <td>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($webhook->status === 'processed'): ?>
                        <span class="text-green-600 font-semibold">Procesado</span>
                    <?php elseif($webhook->status === 'failed'): ?>
                        <span class="text-red-600 font-semibold">Fallido</span>
                    <?php else: ?>
                        <span class="text-yellow-600 font-semibold">Recibido</span>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </td>
                <td class="text-right pr-4">
                    <details>
                        <summary class="cursor-pointer text-purple-600">
                            Ver
                        </summary>
                        <pre class="bg-gray-100 p-3 rounded mt-2 text-xs overflow-x-auto">
<?php echo e(json_encode($webhook->payload, JSON_PRETTY_PRINT)); ?>

                        </pre>
                    </details>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    <div class="mt-4">
        <?php echo e($webhooks->links()); ?>

    </div>

</div>
<?php /**PATH C:\laragon\www\pilates-app\resources\views/livewire/superadmin/openpay/webhooks.blade.php ENDPATH**/ ?>